// $Id: CNativeImage.cpp,v 1.3 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CNativeImage.hpp"
using Exponent::GUI::Graphics::CNativeImage;

//	===========================================================================
CNativeImage::CNativeImage()
			: m_windowHandle(NULL)
			, m_initialised(false)
#ifdef WIN32
			, m_parentHDC(NULL)
#endif
{
	NULL_POINTER(m_windowHandle);
	NULL_POINTER(m_graphicsHandle.m_bitmap);

#ifdef WIN32
	NULL_POINTER(m_graphicsHandle.m_drawContext);
	NULL_POINTER(m_parentHDC);
#endif
	m_initialised = false;
}

//	===========================================================================
CNativeImage::~CNativeImage()
{
	this->destroyNativeImage();
}

#ifdef WIN32
//	===========================================================================
void CNativeImage::initialise(SWindowHandle *windowHandle, HDC drawContext, const CDimension &area)
{
	if (!m_initialised)
	{
		// Store the variables
		m_windowHandle = windowHandle;
		m_parentHDC    = drawContext;
		m_area 		   = area;

		// Null our pointers
		NULL_POINTER(m_graphicsHandle.m_drawContext);
		NULL_POINTER(m_graphicsHandle.m_bitmap);

		// Create a new image
		this->createNativeImage();
	}
}
#else
//	===========================================================================
void CNativeImage::initialise(SWindowHandle *windowHandle, const CDimension &area)
{
	if (!m_initialised)
	{
		// Store the variables
		m_windowHandle = windowHandle;
		m_area 		   = area;

		// Null our pointers
		NULL_POINTER(m_graphicsHandle.m_bitmap);

		// Create a new image
		this->createNativeImage();
	}
}
#endif

//	===========================================================================
void CNativeImage::uninitialise()
{
	if (m_initialised)
	{
		this->destroyNativeImage();
	}
}

//	===========================================================================
void CNativeImage::createNativeImage()
{
	m_initialised = true;
#ifdef WIN32
	// Create the context
	m_graphicsHandle.m_drawContext = CreateCompatibleDC(m_parentHDC);

	// Create the offscreen draw
	m_graphicsHandle.m_bitmap = CreateCompatibleBitmap(m_parentHDC, m_area.getWidth(), m_area.getHeight());

	// Make it available
	SelectObject(m_graphicsHandle.m_drawContext, m_graphicsHandle.m_bitmap);

	// Fill in with their background colour
	RECT winRect = { 0, 0, m_area.getWidth(), m_area.getHeight() };

	// Create the brush
	HBRUSH brush = CreateSolidBrush(m_backgroundColour.getAsColourRef());

	// Make it available
	HGDIOBJ old	 = SelectObject(m_graphicsHandle.m_drawContext, brush);

	// Fill the rectangle
	FillRect(m_graphicsHandle.m_drawContext, &winRect, brush);
	SelectObject(m_graphicsHandle.m_drawContext, old);
	DeleteObject(brush);
#else
	// Create the rectangular size
	Rect myRect = { 0, 0, m_area.getWidth(), m_area.getHeight() };
	
	// Create the graphics world
	NewGWorld(&(m_graphicsHandle.m_bitmap), 0, &myRect, NULL, NULL, 0);
		
#endif
}

//	===========================================================================
void CNativeImage::destroyNativeImage()
{
	m_initialised = false;
#ifdef WIN32
	DeleteDC(m_graphicsHandle.m_drawContext);
	DeleteObject(m_graphicsHandle.m_bitmap);
#else
	DisposeGWorld(m_graphicsHandle.m_bitmap);
#endif
}

//	===========================================================================
void CNativeImage::copyTo(CNativeImage *image)
{
	if (m_initialised && image && image->m_initialised)
	{
	#ifdef WIN32
		BitBlt(image->m_graphicsHandle.m_drawContext, 0, 0, m_area.getWidth(), m_area.getHeight(), m_graphicsHandle.m_drawContext, 0, 0, SRCCOPY);
	#else
		// Get the rectangles that we are copying
		Rect source      = { 0, 0, m_area.getWidth(), m_area.getHeight() };
		Rect destination = { 0, 0, image->m_area.getWidth(), image->m_area.getHeight() };
		
		// Get the pixel information
		PixMapHandle theSourceBits      = GetGWorldPixMap(m_graphicsHandle.m_bitmap);
		PixMapHandle theDestinationBits = GetGWorldPixMap(image->m_graphicsHandle.m_bitmap);

		// Store the colours
		RGBColor savedForeColor, savedBackColor;
		GetForeColor(&savedForeColor);
		GetBackColor(&savedBackColor);
		BackColor(whiteColor);
		ForeColor(blackColor);
			
		// Lock the pixels prior to copy
		LockPixels(theSourceBits);
		LockPixels(theDestinationBits);

		// And copy
		CopyBits((BitMap *) *theSourceBits, (BitMap *) *theDestinationBits, &source, &destination, srcCopy, NULL);
		
		// Unlock the pixels
		UnlockPixels(theSourceBits);
		UnlockPixels(theDestinationBits);

		// Restore the colours
		RGBForeColor(&savedForeColor);
		RGBBackColor(&savedBackColor);
	#endif
	}
}

//	===========================================================================
void CNativeImage::copyFrom(CNativeImage *image)
{
	if (m_initialised && image && image->m_initialised)
	{
	#ifdef WIN32
		BitBlt(m_graphicsHandle.m_drawContext, 0, 0, m_area.getWidth(), m_area.getHeight(), image->m_graphicsHandle.m_drawContext, 0, 0, SRCCOPY);
	#else
		// Get the rectangles that we are copying
		Rect source      = { 0, 0, image->m_area.getWidth(), image->m_area.getHeight() };
		Rect destination = { 0, 0, m_area.getWidth(), m_area.getHeight() };
		
		// Get the pixel information
		PixMapHandle theSourceBits      = GetGWorldPixMap(image->m_graphicsHandle.m_bitmap);
		PixMapHandle theDestinationBits = GetGWorldPixMap(m_graphicsHandle.m_bitmap); 

		// Store the colours
		RGBColor savedForeColor, savedBackColor;
		GetForeColor(&savedForeColor);
		GetBackColor(&savedBackColor);
		BackColor(whiteColor);
		ForeColor(blackColor);
		
		// Lock the pixels prior to copy
		LockPixels(theSourceBits);
		LockPixels(theDestinationBits);

		// And copy
		CopyBits((BitMap *) *theSourceBits, (BitMap *) *theDestinationBits, &source, &destination, srcCopy, NULL);
		
		// Unlock the pixels
		UnlockPixels(theSourceBits);
		UnlockPixels(theDestinationBits);

		// Restore the colours
		RGBForeColor(&savedForeColor);
		RGBBackColor(&savedBackColor);
	#endif
	}
}

//	===========================================================================
void CNativeImage::alphaBlendTo(CNativeImage *image, const CRect &where, const CRect &toHere, const double alpha)
{
	if (m_initialised  && image && image->m_initialised)
	{
	#ifdef WIN32
		// Create and setup our blend function
		BLENDFUNCTION myBlendFunction;
		myBlendFunction.BlendFlags			= 0;
		myBlendFunction.BlendOp				= AC_SRC_OVER;
		myBlendFunction.AlphaFormat		    = AC_SRC_ALPHA;
		myBlendFunction.SourceConstantAlpha = (BYTE)(255.0 * alpha);

		// Perform the alpha blend
		AlphaBlend(image->getGraphicsHandle()->m_drawContext, toHere.getLeft(), toHere.getTop(), toHere.getWidth(), toHere.getHeight(), 
			       m_graphicsHandle.m_drawContext, where.getLeft(), where.getTop(), where.getWidth(), where.getHeight(),
				   myBlendFunction);
	#else
		// Do something on macintosh... Oh the gayness!!!
	#endif
	}
}